#include "../include/typedefs.h"

#define PI 3.14159265358979323846  /* pi */

// Example code from MISRA C:2012 begin
/* Compliant */
int32_t x[ 3 ] = { 0, 1, 3 };

/* Non-compliant - y[ 2 ] is implicitly initialized */
int32_t y[ 3 ] = { 0, 1 };

/* Non-compliant - t[ 0 ] and t[ 3 ] are implicitly initialized */ 
float32_t t[ 4 ] = { [ 1 ] = 1.0f, 2.0f };

/* Compliant - designated initializers for sparse matrix */
float32_t z[ 50 ] = { [ 1 ] = 1.0f, [ 25 ] = 2.0f };

/* Compliant */
float32_t arr[ 3 ][ 2 ] =
{
  { 0.0f, 0.0 },
  { PI / 4.0f, -PI / 4.0f },
  { 0 }  /* initializes all elements of array subobject arr[ 2 ] */
};

char h[ 10 ] = "hello";  /* Compliant by Exception 3 */
// Example code from MISRA C:2012 end
